'******************************************************************************
' ICMP routines (IP required)
'******************************************************************************

'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'
'
'*******************************************************************************
$nocompile                                                  'will compile only as an include file

'-------------------------------------------------------------------------------
' ICMP packet filter
'-------------------------------------------------------------------------------
Sub Icmp_packet_filter
   If Ip_packet_is_for_me() = Nok Then Exit Sub             'Accept only packet for me
   If Icmp_b_type = Icmp_b_type_echoreply Then              'ICMP echo reply
      Call Icmp_received_echo_reply
   End If
   If Icmp_b_type = Icmp_b_type_echorequest Then            'ICMP echo request
      Call Icmp_received_echo_request
   End If

End Sub

'-------------------------------------------------------------------------------
' ICMP Send Echo Reply
'-------------------------------------------------------------------------------
Sub Icmp_send_echo_reply
Local L_pkglen As Word
   'just swap source and destination and send back the package
   Swap Eth_b_src_mac(1) , Eth_b_dest_mac(1)
   Swap Eth_b_src_mac(2) , Eth_b_dest_mac(2)
   Swap Eth_b_src_mac(3) , Eth_b_dest_mac(3)
   Swap Eth_b_src_mac(4) , Eth_b_dest_mac(4)
   Swap Eth_b_src_mac(5) , Eth_b_dest_mac(5)
   Swap Eth_b_src_mac(6) , Eth_b_dest_mac(6)

   Swap Ip_b_srcaddr(1) , Ip_b_destaddr(1)
   Swap Ip_b_srcaddr(2) , Ip_b_destaddr(2)
   Swap Ip_b_srcaddr(3) , Ip_b_destaddr(3)
   Swap Ip_b_srcaddr(4) , Ip_b_destaddr(4)

   Icmp_b_type = Icmp_b_type_echoreply
   Icmp_b_code = &H00

   Call Ip_header_checksum
   Call Icmp_checksum
   L_pkglen = Reversed_word(ip_w_packet_length)
   L_pkglen = L_pkglen + Eth_headerlength
   Call Enc28j60packetsend(l_pkglen)

#if Debug_icmp > 0
   Print
   Print "====================================================================="
   Print "  ICMP Echo reply sent to IP ";
   Call Print_ip(ip_b_destaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_icmp > 2
   Call Icmp_dump_frame
#endif
End Sub

'-------------------------------------------------------------------------------
' ICMP Send Echo Request
'-------------------------------------------------------------------------------
Sub Icmp_send_echo_request(byval Pkglength As Word)
  Local Lw As Word
  Local T_ascii As Byte
  Call Clear_buffer                                         'Clear the complete buffer
'Eth Header
   If Arp_request_destmac_for_ip(icmp_b_target_ip(1)) = Nok Then
      Exit Sub
   End If
   Eth_b_src_mac(1) = My_b_macaddr(1)
   Eth_b_src_mac(2) = My_b_macaddr(2)
   Eth_b_src_mac(3) = My_b_macaddr(3)
   Eth_b_src_mac(4) = My_b_macaddr(4)
   Eth_b_src_mac(5) = My_b_macaddr(5)
   Eth_b_src_mac(6) = My_b_macaddr(6)
   Eth_w_packettype = Eth_w_packettype_ip
'IP Header
   Ip_b_vers_and_length = Ip_standard_vers_and_length
   Ip_b_type_of_service = &H00
   Ip_w_identifier = Ip_get_next_identifier()
   Ip_w_fragmentation = &H0000
   Ip_b_time_to_live = 128
   Ip_b_protocol = Ip_protocol_icmp
   Ip_b_srcaddr(1) = My_b_ipaddr(1)
   Ip_b_srcaddr(2) = My_b_ipaddr(2)
   Ip_b_srcaddr(3) = My_b_ipaddr(3)
   Ip_b_srcaddr(4) = My_b_ipaddr(4)
   Ip_b_destaddr(1) = Icmp_b_target_ip(1)
   Ip_b_destaddr(2) = Icmp_b_target_ip(2)
   Ip_b_destaddr(3) = Icmp_b_target_ip(3)
   Ip_b_destaddr(4) = Icmp_b_target_ip(4)
'ICMP Frame
   Icmp_b_type = &H08                                       ' Echo Request
   Icmp_b_code = &H00
   Icmp_w_identifier = Crc16(ip_b_destaddr(1) , 4)          'some kind of hashing
   Incr Icmp_sequence
   Icmp_w_sequence = Reversed_word(icmp_sequence)           'sequence, may be 0

   T_ascii = Asc( "a")
   For Lw = 43 To Pkglength                                 'fill rest with "abcdef..."
      Buffer(lw) = T_ascii
      Incr T_ascii
      If T_ascii > Asc( "z") Then
         T_ascii = Asc( "a")
       End If
   Next Lw

   Call Ip_set_packet_length(pkglength)
   Call Ip_header_checksum
   Call Icmp_checksum
   Call Enc28j60packetsend(pkglength)

#if Debug_icmp > 0
   Print
   Print "====================================================================="
   Print "  ICMP Echo request sent to IP ";
   Call Print_ip(ip_b_destaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_icmp > 2
   Call Icmp_dump_frame
#endif
End Sub

'-------------------------------------------------------------------------------
' ICMP Received Echo Reply
'-------------------------------------------------------------------------------
Sub Icmp_received_echo_reply
#if Debug_icmp > 0
   Print
   Print "====================================================================="
   Print "  ICMP Echo reply received from IP ";
   Call Print_ip(ip_b_srcaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_icmp > 2
   Call Icmp_dump_frame
#endif

End Sub

'-------------------------------------------------------------------------------
' ICMP Received Echo Request
'-------------------------------------------------------------------------------
Sub Icmp_received_echo_request
#if Debug_icmp > 0
   Print
   Print "====================================================================="
   Print "  ICMP Echo request received from IP ";
   Call Print_ip(ip_b_srcaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_icmp > 2
   Call Icmp_dump_frame
#endif
   Call Icmp_send_echo_reply
End Sub

'-------------------------------------------------------------------------------
'  Routine to calculate a ICMP-checksum
'-------------------------------------------------------------------------------
Sub Icmp_checksum
  Local L_datalen As Word
   Icmp_w_chksum = 0                                        'Initial chksum must be 0 during calculation
'   L_datalen = Makeint(ip_b_packet_length_l , Ip_b_packet_length_h)
   L_datalen = Reversed_word(ip_w_packet_length)
   L_datalen = L_datalen - Ip_headerlength                  'length of ICMP data (without IP-header)
   Icmp_w_chksum = Tcpchecksum(icmp_header_start , L_datalen)
End Sub

'-------------------------------------------------------------------------------
' ICMP set next sequence number
'-------------------------------------------------------------------------------
Function Icmp_set_next_sequence() As Word
   Incr Icmp_sequence
   Icmp_set_next_sequence = Reversed_word(icmp_sequence)
End Function

'-------------------------------------------------------------------------------
' ICMP Debug
'-------------------------------------------------------------------------------
#if Debug_icmp > 2
Sub Icmp_dump_frame
Local Lw As Word
    Call Eth_dump_header
    Call Ip_dump_header
    Print "--------------------------------------------------------------------"
    Print "  ICMP Header (8 Bytes)                                             "
    Print "--------------------------------------------------------------------"
    Print "      Type: " ; : Call Print_word(icmp_b_type , Crlf)
    Print "      Code: " ; : Call Print_word(icmp_b_code , Crlf)
    Print "    Chksum: " ; : Call Print_word(icmp_w_chksum , Crlf)
    Print "Identifier: " ; : Call Print_word(icmp_w_identifier , Crlf)
    Print "SequenceNo: " ; : Call Print_word(icmp_w_sequence , Crlf)
    Lw = Reversed_word(ip_w_packet_length)
    Lw = Lw - 28                                            'Ip-length - IP-Header(20) - ICMP_Header(8)
    Call Dump_buffer(icmp_b_data_start , Lw)
End Sub
#endif
'